//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;
using System.IO;
 
namespace VehicleSerialization
{
	public class VehicleBuilder
	{
		public Vehicle Vehicle(string licenseNumber) 
		{
			if (licenseNumber == "0") 
			{
				Vehicle v = new Car();
				v.licenseNumber = licenseNumber;
				v.make = DateTime.Now;
				return v;
			}
			else if (licenseNumber == "1") 
			{
				Vehicle v = new Bike();
				v.licenseNumber = licenseNumber;
				v.make = DateTime.Now;
				return v;
			}
			else 
			{
				return null;
			}
		}
	}

	// Brak poniszego wiersza powoduje zgoszenie wyjtku
	// Unhandled Exception: System.Exception: There was an error generating the XML document. --->
	// System.Exception: The type VehicleSerialization.Car was not expected.
	// Naley uy atrybutu XmlInclude lub SoapInclude do zdefiniowania typw, ktre nie s statyczne.
	[XmlInclude(typeof(Car)), XmlInclude(typeof(Bike))]
	public abstract class Vehicle 
	{
		public string licenseNumber;
		public DateTime make;
	}
 
	public class Car : Vehicle 
	{
	}
 
	public class Bike : Vehicle 
	{
	}

	public class VehicleSerializationTest
	{
		public static int Main(string[] args)
		{
			VehicleBuilder vb = new VehicleBuilder();
			Vehicle [] va = new Vehicle[2];
			va[0] = vb.Vehicle("0");
			va[1] = vb.Vehicle("1");
			// Utworzenie egzemplarza klasy Soap Serializer;
			// wybr typu obiektu do szeregowania.
			XmlSerializer serializer = 
				new XmlSerializer(typeof(Vehicle[]));
			StreamWriter streamWriter = new StreamWriter("out.xml");
			serializer.Serialize(streamWriter, va);
			streamWriter.Close();

			StreamReader streamReader = new StreamReader("out.xml");
			va = (Vehicle [])serializer.Deserialize(streamReader);
			streamReader.Close();

			Console.WriteLine("Pierwszy element to: {0}", va[0]);
			Console.WriteLine("Drugi element to: {0}", va[1]);

			return 0;
		}
	}
}